class Modal {
    static getContainer() {
        let container = document.getElementById('global-modal-container');
        if (!container) {
            container = document.createElement('div');
            container.id = 'global-modal-container';
            document.body.appendChild(container);
        }
        return container;
    }

    static show({ title, content, type = 'default', confirmText = 'Confirm', cancelText = 'Cancel', input = false, inputValue = '', inputPlaceholder = '' }) {
        return new Promise((resolve) => {
            const container = this.getContainer();

            // Input field html
            let inputHtml = '';
            if (input) {
                inputHtml = `
                    <div class="input-group" style="margin-top: 15px;">
                        <input type="text" class="input modal-input" value="${escapeHtml(inputValue)}" placeholder="${escapeHtml(inputPlaceholder)}" id="modal-input-field">
                    </div>
                `;
            }

            container.innerHTML = `
                <div class="modal-overlay">
                    <div class="modal">
                        <div class="modal-header">
                            <h2 class="modal-title">${escapeHtml(title)}</h2>
                            <button class="modal-close" id="modal-close-btn"><i class="fas fa-times"></i></button>
                        </div>
                        <div class="modal-body" style="color: var(--text-secondary); line-height: 1.5;">
                            ${content}
                            ${inputHtml}
                        </div>
                        <div class="modal-footer">
                            ${type !== 'alert' ? `<button class="btn btn-secondary" id="modal-cancel-btn">${escapeHtml(cancelText)}</button>` : ''}
                            <button class="btn btn-${type === 'danger' ? 'danger' : 'primary'}" id="modal-confirm-btn">${escapeHtml(confirmText)}</button>
                        </div>
                    </div>
                </div>
            `;

            const close = () => {
                container.innerHTML = '';
                resolve(null); // Return null for cancel
            };

            const confirm = () => {
                const inputVal = input ? document.getElementById('modal-input-field').value : true;
                container.innerHTML = '';
                resolve(inputVal);
            };

            document.getElementById('modal-close-btn').onclick = close;
            if (document.getElementById('modal-cancel-btn')) {
                document.getElementById('modal-cancel-btn').onclick = close;
            }

            const confirmBtn = document.getElementById('modal-confirm-btn');
            confirmBtn.onclick = confirm;

            if (input) {
                const inputField = document.getElementById('modal-input-field');
                inputField.focus();
                inputField.select();
                inputField.onkeydown = (e) => {
                    if (e.key === 'Enter') confirm();
                    if (e.key === 'Escape') close();
                };
            }

            // Close on overlay click
            container.querySelector('.modal-overlay').onclick = (e) => {
                if (e.target === e.currentTarget) close();
            };
        });
    }

    static async alert(message, title = 'Alert') {
        return this.show({ title, content: message, type: 'alert', confirmText: 'OK' });
    }

    static async confirm(message, title = 'Confirm', options = {}) {
        return this.show({ title, content: message, type: options.type || 'default', confirmText: 'Yes', cancelText: 'No' });
    }

    static async prompt(message, defaultValue = '', title = 'Input') {
        return this.show({ title, content: message, input: true, inputValue: defaultValue, confirmText: 'OK', cancelText: 'Cancel' });
    }
}
