const express = require('express');
const router = express.Router();
const terminalService = require('../services/terminalService');
const { authenticate } = require('../middleware/auth');

/**
 * POST /api/terminal/execute
 * Execute a terminal command
 */
router.post('/execute', authenticate, async (req, res) => {
    try {
        const { command } = req.body;

        if (!command) {
            return res.status(400).json({ error: 'Command is required' });
        }

        const result = await terminalService.executeCommand(
            command,
            req.user.id,
            req.user.username,
            req.user.permissions
        );

        res.json(result);
    } catch (error) {
        console.error('Terminal execute error:', error);
        res.status(500).json({
            success: false,
            output: `Error: ${error.message}`
        });
    }
});

/**
 * GET /api/terminal/pwd
 * Get current working directory
 */
router.get('/pwd', authenticate, async (req, res) => {
    try {
        const currentDir = terminalService.getCurrentDirectory(req.user.id);
        res.json({ success: true, directory: currentDir });
    } catch (error) {
        console.error('Get pwd error:', error);
        res.status(500).json({ error: 'Failed to get current directory' });
    }
});

module.exports = router;
