require('dotenv').config();

const DISCORD_WEBHOOK_URL = process.env.DISCORD_WEBHOOK_URL;
const DISCORD_WEBHOOK_USER_AUTH = process.env.DISCORD_WEBHOOK_USER_AUTH;
const DISCORD_WEBHOOK_USER_CREATE = process.env.DISCORD_WEBHOOK_USER_CREATE;
const DISCORD_WEBHOOK_FILE_UPLOAD = process.env.DISCORD_WEBHOOK_FILE_UPLOAD;
const DISCORD_WEBHOOK_FOLDER_CREATE = process.env.DISCORD_WEBHOOK_FOLDER_CREATE;
const DISCORD_WEBHOOK_FILE_RENAME = process.env.DISCORD_WEBHOOK_FILE_RENAME;
const DISCORD_WEBHOOK_FILE_MOVE = process.env.DISCORD_WEBHOOK_FILE_MOVE;
const DISCORD_WEBHOOK_FILE_DELETE = process.env.DISCORD_WEBHOOK_FILE_DELETE;

if (!DISCORD_WEBHOOK_URL) {
    console.warn('Warning: DISCORD_WEBHOOK_URL not set. Default Discord notifications will be disabled.');
}

module.exports = {
    DISCORD_WEBHOOK_URL,
    DISCORD_WEBHOOK_USER_AUTH,
    DISCORD_WEBHOOK_USER_CREATE,
    DISCORD_WEBHOOK_FILE_UPLOAD,
    DISCORD_WEBHOOK_FOLDER_CREATE,
    DISCORD_WEBHOOK_FILE_RENAME,
    DISCORD_WEBHOOK_FILE_MOVE,
    DISCORD_WEBHOOK_FILE_DELETE,
    enabled: !!DISCORD_WEBHOOK_URL
};
