const { supabase } = require('./src/config/database');

async function listLogs() {
    try {
        const { data: logs, error } = await supabase
            .from('logs')
            .select(`
                *,
                users:user_id (username)
            `)
            .order('timestamp', { ascending: false })
            .limit(20);

        if (error) {
            console.error('Error fetching logs:', error.message);
            return;
        }

        console.log('--- Recent Activity Logs (Last 20) ---');
        console.table(logs.map(log => ({
            Time: new Date(log.timestamp).toLocaleString(),
            User: log.users?.username || 'System',
            Action: log.action,
            Target: log.target || '-',
            Details: JSON.stringify(log.details)
        })));

    } catch (err) {
        console.error('Unexpected error:', err);
    }
}

listLogs();
